<?php
/*
 * Radian Functions.php
 * Allrights Reserved
 */

// Theme Settings 
require( get_template_directory() . '/admin/functions.php' );
require( get_template_directory() . '/posts/metabox.php' );
 
//Shortens Long Strings with (...)
function max_length($string, $charlength) {
	$charlength++;
	
	if ( mb_strlen( $string ) > $charlength ) {
		$subex = mb_substr( $string, 0, $charlength - 5 );
		$exwords = explode( ' ', $subex );
		$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
		if ( $excut < 0 ) {
			echo mb_substr( $subex, 0, $excut );
		} else {
			echo $subex;
		}
		echo '...';
	} else {
		echo $string;;
	}
}

// Checks if a Cutsom Field is set and is not empty 
function is_field($var) {
	if(isset($var) && !empty($var)) {
		return true;
	}
	else {
		return false;
	}
}

// A short function to call theme files
function get_file($filename) {
	$a = bloginfo('template_directory');
	echo $b = $a . "/" . $filename;
}

// If Search Query Has Only 1 Result,Redirects to the Result
add_action('template_redirect', 'redirect_single_post');
function redirect_single_post() {
	if (is_search()) {
		global $wp_query;
		if ($wp_query->post_count == 1) {
			wp_redirect( get_permalink( $wp_query->posts['0']->ID ) );
		}
	}
}

//HIDE ADMIN PANEL
add_filter( 'show_admin_bar', '__return_false' );
remove_action( 'personal_options', '_admin_bar_preferences' );

// DEREGISTER WP DEFAULT JQUERY
if( !is_admin()) {
	wp_deregister_script('jquery');
	wp_register_script('jquery', false);
	//wp_register_script('jquery', ("http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"), false, '1.7.2');
	wp_enqueue_script('jquery');
}

// Navigation Menus 
register_nav_menus(
	array(
		'top_nav' => 'First Navigation Menu'
	)
);
register_nav_menus(
	array(
		'top_nav' => 'Second Navigation Menu'
	)
);

register_nav_menus(
	array(
		'top_nav' => 'Third Navigation Menu'
	)
);

//POST THUMBNAILS
add_theme_support( 'post-thumbnails' );
if (class_exists('MultiPostThumbnails')) {
	new MultiPostThumbnails(
		array(
			'label' => 'تصویر اسلایدر',
			'id' => 'iv_slider',
			'post_type' => 'product'
		)
	);
	new MultiPostThumbnails(
		array(
			'label' => 'تصویر پیشنهاد شگفت انگیز',
			'id' => 'iv_offer',
			'post_type' => 'product'
		)
	);
}


/**
 * Creates a Pagination Nav!
 * @uses paginate_links()
 * @uses $wp_query
 * @uses get_query_var()
 * 
 * @return string
 */
function BistScriptPagination() {
	global $wp_query;
	$total_pages = $wp_query->max_num_pages;
	if ($total_pages > 1){
	  $current_page = max(1, get_query_var('paged'));	  	  	  if( $current_page < 2 || $current_page == $total_pages ) {				$pn = 6;		}		else {			$pn = 4;		}
	  echo paginate_links(array(
		  'base' => get_pagenum_link(1) . '%_%',
		  'format' => '/page/%#%',
		  'current' => $current_page,
		  'total' => $total_pages,		  		  'end_size' => $pn,		  
		  'prev_text' => '',
		  'next_text' => ''
		));	
	}
}

	function bistscript_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
			// Display trackbacks differently than normal comments.
?>
	
	
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<p><?php _e( 'Pingback:', 'bistscript' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'bistscript' ), '<span class="edit-link">', '</span>' ); ?></p>
	<?php
			break;
		default :
		// Proceed with normal comments.
		global $post;
		
		
		//Check Whether the comment is a Respond or Not
		global $wpdb;
		
		$get_comment_ID = get_comment_ID();
		$respond_query = "SELECT * FROM $wpdb->comments
		WHERE comment_ID = {$get_comment_ID}";
						    
		$rsp = $wpdb->get_results($respond_query);
		
	
		 

		
	?>
	
	
	<div class="comment row<?php foreach ($rsp as $rs) {
		
												if($rs->comment_parent == 0) : echo ""; else : echo " replied"; endif;
									
									
										} ?>" id="li-comment-<?php comment_ID(); ?>">
	
	
	<div class="avatar-reply col">
		<?php echo get_avatar( $comment, 100 ); ?>
		<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'پاسخ دهید', 'bistscript' ), 'after' => '', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>	
	</div>
	<div class="comment-body">
		<div class="comment-body-top row">
			<a class="author" href="<?php comment_author_url(); ?>" rel="nofollow" title="مشاهده وب سایت <?php comment_author(); ?>"><?php comment_author(); ?></a>
			<span class="date"><?php comment_date(__('F jS, Y','kubrick')) ?> </span>
		</div>
			<p id="comment-<?php comment_ID(); ?>" class="comment-texttt">
	


			<?php if ( '0' == $comment->comment_approved ) : ?>
				<p class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'bistscript' ); ?></p>
			<?php endif; ?>

			<section class="comment-content">
				<?php comment_text(); ?>
				<?php edit_comment_link( __( 'Edit', 'bistscript' ), '<p class="edit-link">', '</p>' ); ?>
			</section><!-- .comment-content -->

		
		
		
			</p><!-- #comment-## -->
	</div>
	
		
	</div>
		
	<?php
		break;
	endswitch; // end comment_type check
}


 function bistscript_comment_form( $args = array(), $post_id = null ) {
	global $id;

	if ( null === $post_id )
		$post_id = $id;
	else
		$id = $post_id;

	$commenter = wp_get_current_commenter();
	$user = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';

	$req = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );
	$fields =  array(
		'author' => '<input class="send-form-input" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"' . $aria_req . ' placeholder="نام و نام خانوادگی : ">',
		'email'  => '<input class="send-form-input" id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '"' . $aria_req . ' placeholder="ایمیل : ">',
		'url'    => '<input class="send-form-input" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" placeholder="وب سایت : ">',
	);

	$defaults = array(
		'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
		'comment_field'        => '<textarea class="comment-texttt" id="comment" name="comment" aria-required="true" placeholder="متن : "></textarea>',
		'must_log_in'          => '<p class="must-log-in">' . sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
		'logged_in_as'         => '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>' ), get_edit_user_link(), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
		'comment_notes_before' => '<p class="comment-notes">' . __( 'Your email address will not be published.' ) . ( $req ? $required_text : '' ) . '</p>',
	
		'id_form'              => 'commentform',
		'id_submit'            => 'submit',
		'title_reply'          => __( 'Leave a Reply' ),
		'title_reply_to'       => __( 'Leave a Reply to %s' ),
		'cancel_reply_link'    => __( 'Cancel reply' ),
		'label_submit'         => __( 'Post Comment' ),
	);

	$args = wp_parse_args( $args, apply_filters( 'comment_form_defaults', $defaults ) );

	 if ( comments_open( $post_id ) ) : 

	 do_action( 'comment_form_before' ); ?>
			<div id="respond">
				<small><?php cancel_comment_reply_link( $args['cancel_reply_link'] ); ?></small>
				<div style="position:relative;">
					<?php if ( get_option( 'comment_registration' ) && !is_user_logged_in() ) : ?>
						<?php echo $args['must_log_in']; ?>
						<?php do_action( 'comment_form_must_log_in_after' ); ?>
					<?php else : ?>
						<form action="<?php echo site_url( '/wp-comments-post.php' ); ?>" method="post" id="<?php echo esc_attr( $args['id_form'] ); ?>">
							<?php do_action( 'comment_form_top' ); ?>
							<?php if ( is_user_logged_in() ) : ?>
							<script>
								$("#respond").addClass("comment-as-logged-in-user");
							</script>
								<?php echo apply_filters( 'comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity ); ?>
								<?php do_action( 'comment_form_logged_in_after', $commenter, $user_identity ); ?>
							<?php else : ?>
								<?php
								do_action( 'comment_form_before_fields' );
								foreach ( (array) $args['fields'] as $name => $field ) {
									echo apply_filters( "comment_form_field_{$name}", $field ) . "\n";
								}
								do_action( 'comment_form_after_fields' );
								?>
							<?php endif; ?>
							<?php echo apply_filters( 'comment_form_field_comment', $args['comment_field'] ); ?>
							<?php echo $args['comment_notes_after']; ?>
							<p class="form-submit">
								<input name="submit" type="submit" id="<?php echo esc_attr( $args['id_submit'] ); ?>" value="ارسال دیدگاه" class="send_comment_form_submit">
								<?php comment_id_fields( $post_id ); ?>
							</p>
							<?php do_action( 'comment_form', $post_id ); ?>
						</form>
					<?php endif; ?>
				</div>
			</div><!-- #respond -->
			<!-- www.20script.ir -->
		<?php else :  do_action( 'comment_form_comments_closed' );  endif; }?>